/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import cz.insophy.inplan.util.ChangeTrackingSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultChangeTrackingSet<E>
implements ChangeTrackingSet<E> {
    @Nonnull
    private final Set<E> set;
    @Nonnull
    private ChangeTrackingSet.Changes<E> changes;

    public DefaultChangeTrackingSet() {
        this(Collections.emptySet());
    }

    public DefaultChangeTrackingSet(Set<E> set) {
        this.set = new LinkedHashSet<E>(set);
        this.changes = new ChangeTrackingSet.Changes();
        this.changes.getAdded().addAll(set);
    }

    public static <E> DefaultChangeTrackingSet<E> create() {
        return new DefaultChangeTrackingSet<E>();
    }

    public static <E> DefaultChangeTrackingSet<E> create(Set<E> set) {
        return new DefaultChangeTrackingSet<E>(set);
    }

    @Override
    public boolean add(E e) {
        boolean changed = this.set.add(e);
        if (changed) {
            this.changes.getAdded().add(e);
        }
        return changed;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        boolean changed = this.set.addAll(c);
        this.changes.getAdded().addAll(c);
        return changed;
    }

    @Override
    public void clear() {
        this.changes.getRemoved().addAll(this.set);
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.set.remove(o);
        if (changed) {
            this.changes.getRemoved().add(o);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object element : c) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.set.toArray(a);
    }

    public String toString() {
        return this.set.toString();
    }

    @Override
    public ChangeTrackingSet.Changes<E> getChanges() {
        ChangeTrackingSet.Changes<E> result = this.changes;
        this.changes = new ChangeTrackingSet.Changes();
        return result;
    }
}

